package ru.yandex.webmaster3.viewer.http.feeds.statistics;

import lombok.RequiredArgsConstructor;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.host.service.HostOwnerService;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.services.ServiceInfo;
import ru.yandex.webmaster3.storage.services.SiteServiceType;
import ru.yandex.webmaster3.storage.services.SiteServicesCHDao;
import ru.yandex.webmaster3.storage.services.VerticalShareIsValidatedInfo;
import ru.yandex.webmaster3.storage.services.VerticalShareRatingInfo;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

@ReadAction
@Category("feeds")
@Component("/feeds/verticalShareRating")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetVerticalShareRatingAction extends AbstractUserVerifiedHostAction<GetVerticalShareRatingAction.Request
        , GetVerticalShareRatingAction.Response> {

    private final HostOwnerService hostOwnerService;
    private final SiteServicesCHDao mdbSiteServicesCHDao;

    @Override
    public Response process(Request request) {
        String owner = hostOwnerService.getMascotHostOwner(request.getHostId().getPunycodeHostname());
        var infos = mdbSiteServicesCHDao.getSiteServiceInfo(owner);
        ServiceInfo mbVerticalShareRating = infos.get(SiteServiceType.VERTICAL_SHARE_RATING);
        ServiceInfo mbVerticalShareIsValidated = infos.get(SiteServiceType.VERTICAL_SHARE_IS_VALIDATED);
        double rating = 0;
        if (mbVerticalShareRating != null) {
            rating = ((VerticalShareRatingInfo) mbVerticalShareRating).getRating();
        }
        boolean isValidated = false;
        if (mbVerticalShareIsValidated != null) {
            isValidated = ((VerticalShareIsValidatedInfo) mbVerticalShareIsValidated).isValidated();
        }
        return new Response(rating, isValidated);
    }

    public static final class Request extends AbstractUserVerifiedHostRequest {
    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {
        double rating;
        boolean isValidated;
    }
}
