package ru.yandex.webmaster3.viewer.http.filter;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestFilter;
import ru.yandex.webmaster3.core.http.request.RequestContext;
import ru.yandex.webmaster3.storage.host.HostDataState;
import ru.yandex.webmaster3.storage.sitestructure.SiteStructureService;
import ru.yandex.webmaster3.viewer.http.request.HostDataLoadedRequest;

/**
 * @author avhaliullin
 */
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Description("Данные по хосту должны быть загружены в вебмастер")
public class HostDataLoadedFilter implements RequestFilter<HostDataLoadedRequest, HostDataLoadedFilterResponse> {
    private final SiteStructureService siteStructureService;

    @Override
    public HostDataLoadedFilterResponse beforeRequest(RequestContext ctx, HostDataLoadedRequest req) {
        HostDataState hostDataState = siteStructureService.getHostDataState(req.getHostId());
        if (hostDataState == null) {
            return new HostDataLoadedFilterResponse.HostDataNotLoaded(getClass());
        }
        req.setHostDataState(hostDataState);
        return null;
    }
}
