package ru.yandex.webmaster3.viewer.http.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;

/**
 * @author avhaliullin
 */
public interface HostDataLoadedFilterResponse extends ActionResponse.ErrorResponse {
    enum Code {
        HOST_DATA__HOST_NOT_LOADED,
    }
    @Description("Сайт успешно добавлен в очередь на индесирования. Для начала работы дождитесь появления данных о сайте")
     class HostDataNotLoaded extends WebmasterErrorResponse implements HostDataLoadedFilterResponse {
        public HostDataNotLoaded(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return Code.HOST_DATA__HOST_NOT_LOADED;}
        @Override public Enum<?> getSubsystem() {return WebmasterCommonErrorSystem.HOST_DATA;}
        @Override public String getMessage() {return "Host data not loaded in webmaster";}
    }
}
