package ru.yandex.webmaster3.viewer.http.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;
import ru.yandex.webmaster3.core.http.filter.AbstractFilterError;

/**
 * @author avhaliullin
 */
public interface SpamBannerFilterResponse extends ActionResponse.ErrorResponse {
    enum Codes {
        USER__SPAM_BANED,
    }

    @Description("Запрос классифицирован как спамерский")
    class Banned extends AbstractFilterError implements SpamBannerFilterResponse {
        public Banned(Class<?> clazz, String message) {
            super(clazz, WebmasterCommonErrorSystem.USER, Codes.USER__SPAM_BANED, message);
        }
    }
}
