package ru.yandex.webmaster3.viewer.http.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;
import ru.yandex.webmaster3.core.http.filter.AbstractFilterError;
import ru.yandex.webmaster3.core.spam.ShowCaptchaReason;

/**
 * @author avhaliullin
 */
public interface SpamCaptchaFilterResponse extends ActionResponse.ErrorResponse {
    enum Codes {
        USER__SHOW_CAPTCHA,
    }

    @Description("Просим решить капчу, потом повторить запрос с solvedCaptcha=true")
    class ShowCaptcha extends AbstractFilterError implements SpamCaptchaFilterResponse {
        private final ShowCaptchaReason reason;

        public ShowCaptcha(Class<?> clazz, String message, ShowCaptchaReason reason) {
            super(clazz, WebmasterCommonErrorSystem.USER, Codes.USER__SHOW_CAPTCHA, message);
            this.reason = reason;
        }

        @Description("причина показа капчи")
        public ShowCaptchaReason getReason() {
            return reason;
        }
    }
}
