package ru.yandex.webmaster3.viewer.http.filter;

import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.webmaster3.core.http.RequestFilter;
import ru.yandex.webmaster3.core.http.filter.WebmasterUserFilterResponse;
import ru.yandex.webmaster3.core.http.request.RequestContext;
import ru.yandex.webmaster3.core.http.request.WebmasterUserIdAware;
import ru.yandex.webmaster3.storage.user.service.InitializedUsersService;

/**
 * @author leonidrom
 *
 * Исключительно для облегчения отладки на фронте, чтобы можно было передавать
 * в ручки бэкенда UUID вместо паспортного id.
 */
public class WebmasterUserUUIDFilter implements RequestFilter<WebmasterUserIdAware, WebmasterUserFilterResponse> {
    private final InitializedUsersService initializedUsersService;

    @Autowired
    public WebmasterUserUUIDFilter(InitializedUsersService initializedUsersService) {
        this.initializedUsersService = initializedUsersService;
    }

    @Override
    public WebmasterUserFilterResponse beforeRequest(RequestContext ctx, WebmasterUserIdAware req) {
        if (req.getUserId() < 1 && req.getUserUUID() != null) {
            Long userId = initializedUsersService.getIdByUUIDUncached(req.getUserUUID());
            if (userId != null) {
                req.setUserId(userId);
            }
        }

        return null;
    }
}
