package ru.yandex.webmaster3.viewer.http.geoadv;

import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.geoadv.GeoAdvApiService;
import ru.yandex.webmaster3.storage.geoadv.GeoAdvertisingInfo;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;

@ReadAction
@Category("geoadv")
@Component("/user/host/geoadv")
@AllArgsConstructor(onConstructor_ = @Autowired)
public class GeoAdvAction extends AbstractUserAction<GeoAdvRequest, GeoAdvResponse> {

    private final GeoAdvApiService geoAdvApiService;

    @Override
    public GeoAdvResponse process(GeoAdvRequest request) {
        GeoAdvertisingInfo adv = geoAdvApiService.getGeoAdv(request.getHostId());

        if (adv == null || adv.getGeoAdvertisingResponse() == null){
            return new GeoAdvResponse.OrgNotFoundResponse();
        }
        GeoAdvertisingInfo.GeoAdvertisingResponse advResponse = adv.getGeoAdvertisingResponse();

        GeoAdvertisingInfo.BudgetPrice maxBudgetPrice = advResponse.getMaxBudgetPrice();
        GeoAdvertisingInfo.BudgetPrice minBudgetPrice = advResponse.getMinBudgetPrice();

        if (maxBudgetPrice == null && minBudgetPrice == null){
            return new GeoAdvResponse.BudgetNotCalcResponse();
        }

        // Если один бюджет не посчитан можно взять любой
        maxBudgetPrice = maxBudgetPrice == null? minBudgetPrice: maxBudgetPrice;
        minBudgetPrice = minBudgetPrice == null? maxBudgetPrice: minBudgetPrice;

        GeoAdvertisingInfo.Subscription subscription = minBudgetPrice.getDurations().get(90);

        if (subscription == null){
            return new GeoAdvResponse.BudgetNotCalcResponse();
        }

        if (maxBudgetPrice.getMonthPrediction() == 0) {
            return new GeoAdvResponse.BudgetNotCalcResponse();
        }

        return new GeoAdvResponse.NormalResponse(adv.getPermalink(), maxBudgetPrice.getMonthPrediction(), subscription.getAmount()/3);
    }


}
