package ru.yandex.webmaster3.viewer.http.geoadv;

import lombok.Data;

import ru.yandex.webmaster3.core.http.ActionResponse;

public abstract class GeoAdvResponse implements ActionResponse {
    @Data
    public static class NormalResponse extends GeoAdvResponse implements ActionResponse.NormalResponse {
        private final long permalink;
        private final int clients;
        private final long price;
    }

    enum ErrorCode {
        ORG_NOT_FOUND, BUDGET_NOT_CALC
    }


    public static class OrgNotFoundResponse extends GeoAdvResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<ErrorCode> getCode() {
            return ErrorCode.ORG_NOT_FOUND;
        }
    }

    public static class BudgetNotCalcResponse extends GeoAdvResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<ErrorCode> getCode() {
            return ErrorCode.BUDGET_NOT_CALC;
        }
    }
}
