package ru.yandex.webmaster3.viewer.http.host;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

/**
 * @author avhaliullin
 */
public class AddHostRequest extends AbstractUserRequest {
    private String hostName;
    private boolean forceNotMainMirror = false;

    public String getHostName() {
        return hostName;
    }

    @Description("добавляемый хост")
    @RequestQueryProperty(required = true)
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public boolean isForceNotMainMirror() {
        return forceNotMainMirror;
    }

    @Description("добавить хост, даже если он не является главным зеркалом")
    @RequestQueryProperty(required = false)
    public void setForceNotMainMirror(boolean forceNotMainMirror) {
        this.forceNotMainMirror = forceNotMainMirror;
    }
}
