package ru.yandex.webmaster3.viewer.http.host;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author avhaliullin
 */
public abstract class AddHostResponse implements ActionResponse {
    public static class NormalResponse extends AddHostResponse implements ActionResponse.NormalResponse {
        private final WebmasterHostId hostId;
        private final boolean verified;

        public NormalResponse(WebmasterHostId hostId, boolean verified) {
            this.hostId = hostId;
            this.verified = verified;
        }

        @Description("id добавленного хоста")
        public WebmasterHostId getHostId() {
            return hostId;
        }

        @Description("права на хост автоматически подтверждены")
        public boolean isVerified() {
            return verified;
        }
    }

    public enum Errors {
        ADD_HOST__HOST_ALREADY_ADDED,
        ADD_HOST__NOT_MAIN_MIRROR,
        ADD_HOST__HOSTS_LIMIT_EXCEEDED,
        ADD_HOST__WRONG_HOST,
    }

    public abstract static class AbstractErrorResponse extends AddHostResponse implements ActionResponse.ErrorResponse {
        private final Errors code;

        public AbstractErrorResponse(Errors code) {
            this.code = code;
        }

        @Override
        public Enum<?> getCode() {
            return code;
        }
    }

    @Description("Такой хост уже добавлен")
    public static class HostAlreadyAddedError extends AbstractErrorResponse {
        private final WebmasterHostId hostId;
        private final boolean verified;

        public HostAlreadyAddedError(WebmasterHostId hostId, boolean verified) {
            super(Errors.ADD_HOST__HOST_ALREADY_ADDED);
            this.hostId = hostId;
            this.verified = verified;
        }

        @Description("id хоста")
        public WebmasterHostId getHostId() {
            return hostId;
        }

        @Description("подтвержден ли добавленный хост")
        public boolean isVerified() {
            return verified;
        }
    }

    @Description("Добавляемый хост не является главным зеркалом")
    public static class NotMainMirrorError extends AbstractErrorResponse {
        private final WebmasterHostId hostId;
        private final WebmasterHostId mainMirrorId;
        private final boolean mainMirrorAdded;
        private final boolean mainMirrorVerified;

        public NotMainMirrorError(WebmasterHostId hostId, WebmasterHostId mainMirrorId, boolean mainMirrorAdded, boolean mainMirrorVerified) {
            super(Errors.ADD_HOST__NOT_MAIN_MIRROR);
            this.hostId = hostId;
            this.mainMirrorId = mainMirrorId;
            this.mainMirrorAdded = mainMirrorAdded;
            this.mainMirrorVerified = mainMirrorVerified;
        }

        @Description("id добавляемого хоста")
        public WebmasterHostId getHostId() {
            return hostId;
        }

        @Description("id главного зеркала")
        public WebmasterHostId getMainMirrorId() {
            return mainMirrorId;
        }

        @Description("добавлено ли главное зеркало")
        public boolean isMainMirrorAdded() {
            return mainMirrorAdded;
        }

        @Description("подтверждено ли главное зеркало")
        public boolean isMainMirrorVerified() {
            return mainMirrorVerified;
        }
    }

    @Description("Превышен лимит количества хостов")
    public static class HostsLimitExceededError extends AbstractErrorResponse {
        private final int limit;

        public HostsLimitExceededError(int limit) {
            super(Errors.ADD_HOST__HOSTS_LIMIT_EXCEEDED);
            this.limit = limit;
        }

        @Description("лимит количества хостов")
        public int getLimit() {
            return limit;
        }
    }

    @Description("Некорректный хост")
    public static class WrongHostError extends AbstractErrorResponse {

        public WrongHostError() {
            super(Errors.ADD_HOST__WRONG_HOST);
        }
    }
}
