package ru.yandex.webmaster3.viewer.http.host;

import lombok.Value;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.viewer.http.common.response.CommonHostInfo;
import ru.yandex.webmaster3.viewer.http.common.response.HostDataStatus;

/**
 * @author aherman
 */
public abstract class GetHostInfoResponse implements ActionResponse {
    @Value
    public static class NormalResponse extends GetHostInfoResponse implements ActionResponse.NormalResponse {
        CommonHostInfo hostname;
        HostDataStatus hostDataStatus;
        @Description("id главного зеркала")
        WebmasterHostId mainMirrorHostId;
        @Description("добавлено ли главное зеркало")
        Boolean isMainMirrorAdded;
        boolean isCommercial;
    }
}
