package ru.yandex.webmaster3.viewer.http.host;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.host.service.HostOwnerService;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.user.UserVerifiedHost;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.user.service.UserHostsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserAddedHostAction;

/**
 * Created by ifilippov5 on 04.07.18.
 */
@ReadAction
@Category("verification")
@Component("/host/ownerInfo")
public class GetHostOwnerInfoAction extends AbstractUserAddedHostAction<GetHostOwnerInfoRequest, GetHostOwnerInfoResponse> {
    private final HostOwnerService hostOwnerService;
    private final UserHostsService userHostsService;

    @Autowired
    public GetHostOwnerInfoAction(HostOwnerService hostOwnerService, UserHostsService userHostsService) {
        this.hostOwnerService = hostOwnerService;
        this.userHostsService = userHostsService;
    }

    @Override
    public GetHostOwnerInfoResponse process(GetHostOwnerInfoRequest request) {
        WebmasterHostId ownerHostId = hostOwnerService.getMascotHostOwner(request.getHostId());
        final List<WebmasterHostId> webmasterHostIds = IdUtils.allHostsForDomainWithM(ownerHostId);
        if (webmasterHostIds.contains(request.getHostId())) {
            return new GetHostOwnerInfoResponse.NormalResponse(ownerHostId.getReadableHostname(), null);
        }
        final List<UserVerifiedHost> verifiedHosts = userHostsService.getVerifiedHosts(request.getWebmasterUser(), webmasterHostIds);
        if (verifiedHosts.size() > 0) {
            return new GetHostOwnerInfoResponse.NormalResponse(ownerHostId.getReadableHostname(), verifiedHosts.get(0).getWebmasterHostId());
        } else {
            return new GetHostOwnerInfoResponse.NormalResponse(ownerHostId.getReadableHostname(), webmasterHostIds.get(0));
        }
    }
}
