package ru.yandex.webmaster3.viewer.http.host;

import java.util.List;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * Created by ifilippov5 on 04.07.18.
 */
public abstract class GetHostOwnerInfoResponse implements ActionResponse {
    public static class NormalResponse extends GetHostOwnerInfoResponse implements ActionResponse.NormalResponse {
        private final String ownerDomain;
        private final WebmasterHostId hostToRedirect;

        public NormalResponse(String ownerDomain, WebmasterHostId hostToRedirect) {
            this.ownerDomain = ownerDomain;
            this.hostToRedirect = hostToRedirect;
        }

        @Description("Оунер хоста")
        public String getOwnerDomain() {
            return ownerDomain;
        }

        @Description("Хост для редиректа как на главной")
        public WebmasterHostId getHostToRedirect(){
            return hostToRedirect;
        }
    }
}
