package ru.yandex.webmaster3.viewer.http.host;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.oldwmc.OldWmcHostIdsYDao;
import ru.yandex.webmaster3.viewer.http.BaseWebmaster3Action;

/**
 * @author avhaliullin
 */
@Description("Получить id хоста в новом вебмастере по id в старом")
@ReadAction
@Category("verification")
@Service("/host/convertHostId")
public class GetNewHostIdFromOldIdAction extends BaseWebmaster3Action<GetNewHostIdFromOldIdRequest, GetNewHostIdFromOldIdResponse> {
    private final OldWmcHostIdsYDao oldWmcHostIdsYDao;

    @Autowired
    public GetNewHostIdFromOldIdAction(OldWmcHostIdsYDao oldWmcHostIdsYDao) {
        this.oldWmcHostIdsYDao = oldWmcHostIdsYDao;
    }

    @Override
    public GetNewHostIdFromOldIdResponse process(GetNewHostIdFromOldIdRequest request) {
        String hostIdStr = request.getHostId();
        WebmasterHostId hostId;
        try {
            hostId = oldWmcHostIdsYDao.get(Long.parseLong(hostIdStr));
        } catch (NumberFormatException e) {
            hostId = IdUtils.stringToHostId(hostIdStr);
        }

        return new GetNewHostIdFromOldIdResponse(hostId);
    }
}

