package ru.yandex.webmaster3.viewer.http.host;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;

/**
 * @author avhaliullin
 */
public class GetNewHostIdFromOldIdResponse implements ActionResponse.NormalResponse {
    private final WebmasterHostId hostId;

    public GetNewHostIdFromOldIdResponse(WebmasterHostId hostId) {
        this.hostId = hostId;
    }

    @Description("id хоста в новом вебмастере (или null, если хост в старом не нашелся)")
    public WebmasterHostId getHostId() {
        return hostId;
    }
}
