package ru.yandex.webmaster3.viewer.http.host.delegation;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author avhaliullin
 */
public abstract class DelegateHostResponse implements ActionResponse {
    public static class NormalResponse extends DelegateHostResponse implements ActionResponse.NormalResponse {
        private final long toUserId;
        private final boolean hostAddedByUser;

        public NormalResponse(long toUserId, boolean hostAddedByUser) {
            this.toUserId = toUserId;
            this.hostAddedByUser = hostAddedByUser;
        }

        @Description("id пользователя, которому делегируем права")
        public long getToUserId() {
            return toUserId;
        }

        @Description("добавлен ли сайт пользователем, которому мы делегировали права")
        public boolean isHostAddedByUser() {
            return hostAddedByUser;
        }
    }

    public enum Errors {
        DELEGATE_HOST__DAILY_DELEGATIONS_LIMIT_EXCEEDED,
        DELEGATE_HOST__NOT_DELEGATABLE_VERIFICATION,
        DELEGATE_HOST__ALREADY_VERIFIED_FOR_USER,
        DELEGATE_HOST__ALREADY_DELEGATED_FOR_USER,
        DELEGATE_HOST__USER_NOT_FOUND,
    }

    public abstract static class AbstractError extends DelegateHostResponse implements ActionResponse.ErrorResponse {
        private final Errors code;

        public AbstractError(Errors code) {
            this.code = code;
        }

        @Override
        public Errors getCode() {
            return code;
        }
    }

    @Description("Превышен суточный лимит делегирований от текущего пользователя")
    public static class DailyDelegationsLimitExceededError extends AbstractError {
        private final long delegationsLimit;

        public DailyDelegationsLimitExceededError(long delegationsLimit) {
            super(Errors.DELEGATE_HOST__DAILY_DELEGATIONS_LIMIT_EXCEEDED);
            this.delegationsLimit = delegationsLimit;
        }

        @Description("Лимит делегирований от пользователя в сутки")
        public long getDelegationsLimit() {
            return delegationsLimit;
        }
    }

    @Description("Пользователь подтвердил свои права способом, не разрешающим делегирование (например, читерски из админки)")
    public static class NotDelegatableError extends AbstractError {
        public NotDelegatableError() {
            super(Errors.DELEGATE_HOST__NOT_DELEGATABLE_VERIFICATION);
        }
    }

    @Description("Права на сайт для выбранного пользователя уже подтверждены")
    public static class AlreadyVerifiedError extends AbstractError {
        public AlreadyVerifiedError() {
            super(Errors.DELEGATE_HOST__ALREADY_VERIFIED_FOR_USER);
        }
    }

    @Description("Сайт уже делегирован указанному пользователю")
    public static class AlreadyDelegatedError extends AbstractError {
        public AlreadyDelegatedError() {
            super(Errors.DELEGATE_HOST__ALREADY_DELEGATED_FOR_USER);
        }
    }

    @Description("Такого пользователя нет в паспорте")
    public static class UserNotFoundError extends AbstractError {
        public UserNotFoundError() {
            super(Errors.DELEGATE_HOST__USER_NOT_FOUND);
        }
    }
}
