package ru.yandex.webmaster3.viewer.http.host.feedback;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

import java.util.List;

/**
 * @author avhaliullin
 */
public class FeedbackUserAddedHostsResponse implements ActionResponse.NormalResponse {
    private final List<Host> hosts;

    public FeedbackUserAddedHostsResponse(List<Host> hosts) {
        this.hosts = hosts;
    }

    public List<Host> getHosts() {
        return hosts;
    }

    public static class Host {
        private WebmasterHostId id;
        private String name;
        private String punycodeName;
        private boolean verified;
        private boolean isMainMirror;

        public Host(WebmasterHostId id, String name, String punycodeName, boolean verified, boolean isMainMirror) {
            this.id = id;
            this.name = name;
            this.punycodeName = punycodeName;
            this.verified = verified;
            this.isMainMirror = isMainMirror;
        }

        public WebmasterHostId getId() {
            return id;
        }

        public String getName() {
            return name;
        }

        public String getPunycodeName() {
            return punycodeName;
        }

        public boolean isVerified() {
            return verified;
        }

        public boolean isMainMirror() {
            return isMainMirror;
        }
    }
}
