package ru.yandex.webmaster3.viewer.http.host.verification;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.host.verification.VerificationTypeScope;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.verification.HostVerifierService;
import ru.yandex.webmaster3.viewer.http.AbstractUserAddedHostAction;

/**
 * @author avhaliullin
 */
@Description("Выводит список типов подтверждений, доступных для выбранного хоста")
@ReadAction
@Category("verification")
public class ApplicableVerificationsAction extends AbstractUserAddedHostAction<ApplicableVerificationsRequest, ApplicableVerificationsResponse> {
    private HostVerifierService hostVerifierService;

    @Override
    public ApplicableVerificationsResponse process(ApplicableVerificationsRequest request) {
        return new ApplicableVerificationsResponse(
                hostVerifierService.listApplicable(request.getHostId(), request.getUserId(), VerificationTypeScope.VIEWER)
        );
    }

    @Required
    public void setHostVerifierService(HostVerifierService hostVerifierService) {
        this.hostVerifierService = hostVerifierService;
    }
}
