package ru.yandex.webmaster3.viewer.http.host.verification;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author avhaliullin
 */
public abstract class CancelVerificationProcessResponse implements ActionResponse {
    public static class NormalResponse extends CancelVerificationProcessResponse implements ActionResponse.NormalResponse {
    }

    public enum Errors {
        CANCEL_VERIFICATION__NO_VERIFICATION_IN_PROGRESS,
    }

    @Description("В данный момент проверка прав не ведется")
    public static class NoVerificationInProgressError extends CancelVerificationProcessResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return Errors.CANCEL_VERIFICATION__NO_VERIFICATION_IN_PROGRESS;
        }
    }
}
