package ru.yandex.webmaster3.viewer.http.host.verification;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.host.verification.VerificationType;
import ru.yandex.webmaster3.core.host.verification.UinUtil;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

import java.util.List;

/**
 * @author avhaliullin
 */
public class UsersVerifiedHostResponse implements ActionResponse.NormalResponse {
    private final List<UserInfo> users;

    public UsersVerifiedHostResponse(List<UserInfo> users) {
        this.users = users;
    }

    public List<UserInfo> getUsers() {
        return users;
    }

    public static class UserInfo {
        private final long userId;
        private final VerificationType verificationType;
        private final DateTime verificationDate;
        private final String verificationUin;
        private final Long delegatedByUserId;

        public UserInfo(long userId, VerificationType verificationType, DateTime verificationDate, long verificationUin, Long delegatedByUserId) {
            this.userId = userId;
            this.verificationType = verificationType;
            this.verificationDate = verificationDate;
            this.verificationUin = UinUtil.getUinString(verificationUin);
            this.delegatedByUserId = delegatedByUserId;
        }

        public String getVerificationUin() {
            return verificationUin;
        }

        public long getUserId() {
            return userId;
        }

        public VerificationType getVerificationType() {
            return verificationType;
        }

        public DateTime getVerificationDate() {
            return verificationDate;
        }

        @Description("uid пользователя, делегировавшего права (если права делегированы)")
        public Long getDelegatedByUserId() {
            return delegatedByUserId;
        }
    }
}
