package ru.yandex.webmaster3.viewer.http.host.verification;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author avhaliullin
 */
public abstract class VerifyHostResponse implements ActionResponse {
    public static class NormalResponse extends VerifyHostResponse implements ActionResponse.NormalResponse {
    }

    public enum Errors {
        VERIFY_HOST__ALREADY_VERIFIED,
        VERIFY_HOST__VERIFICATION_IS_IN_PROGRESS,
        VERIFY_HOST__VERIFICATION_NOT_APPLICABLE,
    }

    public abstract static class AbstractError extends VerifyHostResponse implements ActionResponse.ErrorResponse {
        private final Errors code;

        protected AbstractError(Errors code) {
            this.code = code;
        }

        @Override
        public Enum<?> getCode() {
            return code;
        }
    }

    @Description("хост уже подтвержден пользователем")
    public static class AlreadyVerifiedError extends AbstractError {
        public AlreadyVerifiedError() {
            super(Errors.VERIFY_HOST__ALREADY_VERIFIED);
        }
    }

    @Description("в данный момент хост уже проходит проверку")
    public static class VerificationIsInProgressError extends AbstractError {
        public VerificationIsInProgressError() {
            super(Errors.VERIFY_HOST__VERIFICATION_IS_IN_PROGRESS);
        }
    }

    @Description("выбранный способ потверждения неприменим для этого хоста")
    public static class VerificationNotApplicable extends AbstractError{
        public VerificationNotApplicable() {
            super(Errors.VERIFY_HOST__VERIFICATION_NOT_APPLICABLE);
        }
    }
}
