package ru.yandex.webmaster3.viewer.http.hoststat;

import lombok.RequiredArgsConstructor;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.hoststat.HostStatistics;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.hoststat.HostStatisticsInfo;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.hoststat.HostStatisticsCHDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;
import ru.yandex.webmaster3.viewer.http.hoststat.GetDashboardHostContentStatisticsAction.Request;
import ru.yandex.webmaster3.viewer.http.hoststat.GetDashboardHostContentStatisticsAction.Response;

/**
 * Created by Oleg Bazdyrev on 12/03/2021.
 */
@Category("checklist")
@ReadAction
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("/dashboard/checklist/hostContentStatistics")
public class GetDashboardHostContentStatisticsAction extends AbstractUserVerifiedHostAction<Request, Response> {

    private final HostStatisticsCHDao hostStatisticsCHDao;

    @Override
    public Response process(Request request) {
        HostStatistics statistics = hostStatisticsCHDao.getHostStatisticsWithoutSamples(request.getHostId());
        return new Response(HostStatisticsInfo.fromHostStatistics(statistics));
    }

    public static final class Request extends AbstractUserVerifiedHostRequest {

    }

    @Value
    public static final class Response implements ActionResponse.NormalResponse {
        @Description("Общая статистика по хосту")
        HostStatisticsInfo hostStatistics;
    }

}
