package ru.yandex.webmaster3.viewer.http.hoststat.download;

import com.google.common.hash.Hasher;
import lombok.Getter;
import lombok.Setter;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.AbstractFilter;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;
import ru.yandex.webmaster3.storage.hoststat.download.ContentAttrSamplesMdsExportDescriptor;
import ru.yandex.webmaster3.storage.hoststat.download.ContentAttrSamplesMdsExportDescriptor.ContentAttrType;
import ru.yandex.webmaster3.viewer.http.download.DownloadAction2;
import ru.yandex.webmaster3.viewer.http.download.DownloadRequest;

/**
 * Created by Oleg Bazdyrev on 16/03/2021.
 */
@ReadAction
@Description("Скачать примеры дублирующихся тайтлов")
@Category("checklist")
@Component("/checklist/contentAttrSamples/download")
public class DownloadContentAttrSamplesAction extends DownloadAction2<DownloadContentAttrSamplesAction.Request> {

    @Override
    protected MdsExportDescriptor makeRequest(Request request) {
        String host = IdUtils.hostIdToUrl(request.getHostId());
        return new ContentAttrSamplesMdsExportDescriptor(request.getContentAttrType(), host);
    }

    @Override
    protected void customizeHash(Hasher h, Request request) {
        h.putBytes(getClass().getName().getBytes());
        h.putBytes(request.getContentAttrType().name().getBytes());
    }


    public static final class Request extends DownloadRequest<ContentAttrSamplesMdsExportField, ContentAttrSamplesMdsExportFilter> {
        @Description("Тип скачиваемых данных")
        @Getter
        @Setter(onMethod_ = @RequestQueryProperty(required = true))
        private ContentAttrType contentAttrType;
    }

    public static final class ContentAttrSamplesMdsExportFilter extends AbstractFilter<ContentAttrSamplesMdsExportField> {

        public ContentAttrSamplesMdsExportFilter(ContentAttrSamplesMdsExportField indicator, Operation operation, String value) {
            super(indicator, operation, value);
        }
    }

    public enum ContentAttrSamplesMdsExportField {

    }

}
