package ru.yandex.webmaster3.viewer.http.importanturls;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.importanturls.data.ImportantUrl;

import java.util.List;

/**
 * @author avhaliullin
 */
public class AddAllRecommendedUrlsResponse implements ActionResponse {
    private final int quota;
    private final int quotaUsed;
    private final int quotaRemain;
    private final List<ImportantUrl> urls;

    public AddAllRecommendedUrlsResponse(int quota, int quotaUsed, int quotaRemain, List<ImportantUrl> urls) {
        this.quota = quota;
        this.quotaUsed = quotaUsed;
        this.quotaRemain = quotaRemain;
        this.urls = urls;
    }

    public int getQuota() {
        return quota;
    }

    public int getQuotaUsed() {
        return quotaUsed;
    }

    public int getQuotaRemain() {
        return quotaRemain;
    }

    @Description("Список успешно добавленных подписок на страницы")
    public List<ImportantUrl> getUrls() {
        return urls;
    }

    @Override
    public ActionStatus getRequestStatus() {
        return ActionStatus.SUCCESS;
    }
}
