package ru.yandex.webmaster3.viewer.http.importanturls;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

import java.util.List;

/**
 * @author Oleg Bazdyrev
 * @see WMC-3620
 */
@Description("Запрос на добавление подписки на важные страницы")
public class AddImportantUrlsRequest extends AbstractUserVerifiedHostRequest {

    private List<String> urls;

    public List<String> getUrls() {
        return urls;
    }

    @RequestPostProperty(required = true)
    @Description("Список URL, на изменения которых необходимо подписаться")
    public void setUrls(List<String> urls) {
        this.urls = urls;
    }
}
