package ru.yandex.webmaster3.viewer.http.importanturls;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.importanturls.data.ImportantUrl;

import java.util.List;

import static ru.yandex.webmaster3.viewer.http.importanturls.AddImportantUrlsResponse.ErrorType.ADD_IMPORTANT_URLS__QUOTA_EXCEEDED;

/**
 * @author Oleg Bazdyrev
 * @see WMC-3620
 */
public abstract class AddImportantUrlsResponse implements ActionResponse {

    private final int quota;
    private final int quotaUsed;
    private final int quotaRemain;

    public AddImportantUrlsResponse(int quota, int quotaUsed, int quotaRemain) {
        this.quota = quota;
        this.quotaUsed = quotaUsed;
        this.quotaRemain = quotaRemain;
    }

    public int getQuota() {
        return quota;
    }

    public int getQuotaUsed() {
        return quotaUsed;
    }

    public int getQuotaRemain() {
        return quotaRemain;
    }

    public enum ErrorType {
        @Description("Превышен лимит подписок на один хост")
        ADD_IMPORTANT_URLS__QUOTA_EXCEEDED,
    }

    public enum WarningType {
        @Description("Есть один или несколько невалидных URL-ов")
        ADD_IMPORTANT_URLS__INVALID_URLS;
    }

    public static class NormalResponse extends AddImportantUrlsResponse implements ActionResponse.NormalResponse {

        private final List<ImportantUrl> urls;
        private final List<String> invalidUrls;
        private final WarningType warning;

        public NormalResponse(int quota, int quotaUsed, int quotaRemain, List<ImportantUrl> urls,
                              List<String> invalidUrls, WarningType warning) {
            super(quota, quotaUsed, quotaRemain);
            this.urls = urls;
            this.invalidUrls = invalidUrls;
            this.warning = warning;
        }

        @Description("Список успешно добавленных подписок на страницы")
        public List<ImportantUrl> getUrls() {
            return urls;
        }

        @Description("Список ошибочных URL (невалидный формат, принадлежность к другому хосту)")
        public List<String> getInvalidUrls() {
            return invalidUrls;
        }

        @Description("Признак какой-либо проблемы при добавлении (пока только наличие невалидных URL-ов)")
        public WarningType getWarning() {
            return warning;
        }
    }

    public static abstract class ErrorResponse extends AddImportantUrlsResponse implements ActionResponse.ErrorResponse {

        private final ErrorType errorType;

        public ErrorResponse(int quota, int quotaUsed, int quotaRemain, ErrorType errorType) {
            super(quota, quotaUsed, quotaRemain);
            this.errorType = errorType;
        }

        @Override
        public Enum<?> getCode() {
            return errorType;
        }

    }

    public static class QuotaExceededResponse extends ErrorResponse {

        private final int urlCount;

        public QuotaExceededResponse(int quota, int quotaUsed, int quotaRemain, int urlCount) {
            super(quota, quotaUsed, quotaRemain, ADD_IMPORTANT_URLS__QUOTA_EXCEEDED);
            this.urlCount = urlCount;
        }

        @Description("Сколько страниц пытался добавить пользователь")
        public int getUrlCount() {
            return urlCount;
        }

        @Override
        public String getMessage() {
            return "Subscription number quota per host reached";
        }
    }

}
