package ru.yandex.webmaster3.viewer.http.importanturls;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.importanturls.ImportantUrlsYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author Oleg Bazdyrev
 */
@WriteAction
@Description("Удаление подписки на страницу")
@Category("importanturls")
public class DeleteImportantUrlAction extends
        AbstractUserVerifiedHostAction<DeleteImportantUrlRequest, DeleteImportantUrlResponse> {

    private ImportantUrlsYDao importantUrlsYDao;

    @Override
    public DeleteImportantUrlResponse process(DeleteImportantUrlRequest request) {
        try {
            importantUrlsYDao.delete(request.getHostId(), request.getUrl());
        } catch (Exception e) {
            return new DeleteImportantUrlResponse.InvalidUrlResponse();
        }
        return new DeleteImportantUrlResponse.NormalResponse();
    }

    @Required
    public void setImportantUrlsYDao(ImportantUrlsYDao importantUrlsYDao) {
        this.importantUrlsYDao = importantUrlsYDao;
    }

}
