package ru.yandex.webmaster3.viewer.http.importanturls;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

import static ru.yandex.webmaster3.viewer.http.importanturls.DeleteImportantUrlResponse.ErrorType.DELETE_IMPORTANT_URL__INVALID_URL;

/**
 * @author Oleg Bazdyrev
 */
public abstract class DeleteImportantUrlResponse implements ActionResponse {

    public enum ErrorType {
        DELETE_IMPORTANT_URL__INVALID_URL;
    }

    public static class NormalResponse extends DeleteImportantUrlResponse implements ActionResponse.NormalResponse {
    }

    public static abstract class ErrorResponse extends DeleteImportantUrlResponse implements ActionResponse.ErrorResponse {

        private final ErrorType errorType;

        public ErrorResponse(ErrorType errorType) {
            this.errorType = errorType;
        }

        @Override
        public Enum<?> getCode() {
            return errorType;
        }
    }

    public static class InvalidUrlResponse extends ErrorResponse {

        public InvalidUrlResponse() {
            super(DELETE_IMPORTANT_URL__INVALID_URL);
        }
    }

}
