package ru.yandex.webmaster3.viewer.http.importanturls;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.importanturls.ImportantUrlsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author Oleg Bazdyrev
 */
@ReadAction
@Description("Получение истории статусов для одной или нескольких важных страниц")
@Category("importanturls")
public class GetImportantUrlStatusesAction extends
        AbstractUserVerifiedHostAction<GetImportantUrlStatusesRequest, GetImportantUrlStatusesResponse> {

    @Autowired
    private ImportantUrlsService importantUrlsService;

    @Override
    public GetImportantUrlStatusesResponse process(GetImportantUrlStatusesRequest request) {
        return new GetImportantUrlStatusesResponse.NormalResponse(
                importantUrlsService.getHistory(request.getHostId(), request.getUrl()));
    }

}
