package ru.yandex.webmaster3.viewer.http.importanturls;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author Oleg Bazdyrev
 */
@Description("Запрос на получение истории статусов по одной странице")
public class GetImportantUrlStatusesRequest extends AbstractUserVerifiedHostRequest {

    private String url;
    private int limit = 100;
    private int skip = 0;

    public String getUrl() {
        return url;
    }

    @RequestQueryProperty(required = true)
    @Description("Адрес страницы, история статусов которой интересует")
    public void setUrl(String url) {
        this.url = url;
    }

    public int getLimit() {
        return limit;
    }

    @RequestQueryProperty
    @Description("Ограничить количество результатов указанным числом (по отдельности на каждый URL)")
    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getSkip() {
        return skip;
    }

    @Description("Пропустить первые skip результатов. По умолчанию - 0")
    @RequestQueryProperty
    public void setSkip(int skip) {
        this.skip = skip;
    }
}
