package ru.yandex.webmaster3.viewer.http.importanturls;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.importanturls.data.ImportantUrlStatus;

import java.util.List;

/**
 * @author Oleg Bazdyrev
 */
@Description("Ответ на запрос истории статусов важной страницы")
public abstract class GetImportantUrlStatusesResponse implements ActionResponse {

    public enum ErrorType {
        @Description("Переданный URL невалиден")
        GET_IMPORTANT_URL_STATUSES__INVALID_URL;
    }

    public static class NormalResponse extends GetImportantUrlStatusesResponse implements ActionResponse.NormalResponse {

        private final List<ImportantUrlStatus> statuses;

        public NormalResponse(List<ImportantUrlStatus> statuses) {
            this.statuses = statuses;
        }

        @Description("Список статусов в порядке убывания времени обновления статуса")
        public List<ImportantUrlStatus> getStatuses() {
            return statuses;
        }
    }

    public static class InvalidUrlResponse extends GetImportantUrlStatusesResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return ErrorType.GET_IMPORTANT_URL_STATUSES__INVALID_URL;
        }

        @Override
        public String getMessage() {
            return "URL is invalid";
        }
    }
}
