package ru.yandex.webmaster3.viewer.http.importanturls;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.importanturls.ImportantUrlsService;
import ru.yandex.webmaster3.storage.importanturls.data.ImportantUrl;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author Oleg Bazdyrev
 */
@ReadAction
@Description("Получение списка подписок по хосту")
@Category("importanturls")
public class GetImportantUrlsAction extends AbstractUserVerifiedHostAction<GetImportantUrlsRequest, GetImportantUrlsResponse> {
    @Autowired
    private ImportantUrlsService importantUrlsService;

    @Override
    public GetImportantUrlsResponse process(GetImportantUrlsRequest request) {
        List<ImportantUrl> importantUrls = importantUrlsService.listImportantUrls(request.getHostId());
        // сортируем по дате последнего обновления
        importantUrls.sort(ImportantUrl.BY_UPDATE_TIME_AND_RELATIVE_URL.reversed());
        ImportantUrlsService.ImportantUrlsQuota quota =
                importantUrlsService.getImportantUrlsQuota(request.getHostId());
        // фронт сам высчитывает remain, поэтому quotaRemain скорее всего не используется
        ImportantUrlsStatCollector statCollector = new ImportantUrlsStatCollector();
        importantUrls.forEach(statCollector::update);
        return new GetImportantUrlsResponse(quota.getQuotaTotal(), quota.getQuotaUsed(), quota.getQuotaRemain(), importantUrls, statCollector.getResult());
    }
}
