package ru.yandex.webmaster3.viewer.http.importanturls;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.importanturls.ImportantUrlsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author Oleg Bazdyrev
 */
@ReadAction
@Description("Запрос на получение квоты подписки на изменения важных страниц")
@Category("importanturls")
public class GetImportantUrlsQuotaAction extends
        AbstractUserVerifiedHostAction<GetImportantUrlsQuotaRequest, GetImportantUrlsQuotaResponse> {

    @Autowired
    private ImportantUrlsService importantUrlsService;

    @Override
    public GetImportantUrlsQuotaResponse process(GetImportantUrlsQuotaRequest request) {
        ImportantUrlsService.ImportantUrlsQuota quota =
                importantUrlsService.getImportantUrlsQuota(request.getHostId());
        return new GetImportantUrlsQuotaResponse(quota.getQuotaTotal(), quota.getQuotaUsed(), quota.getQuotaRemain());
    }

}
