package ru.yandex.webmaster3.viewer.http.importanturls;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author Oleg Bazdyrev
 * @see WMC-3620
 */
@Description("Ответ на запрос информации о квоте подписок на важные страницы")
public class GetImportantUrlsQuotaResponse implements ActionResponse.NormalResponse {

    private final int quota;
    private final int quotaUsed;
    private final int quotaRemain;

    public GetImportantUrlsQuotaResponse(int quota, int quotaUsed, int quotaRemain) {
        this.quota = quota;
        this.quotaUsed = quotaUsed;
        this.quotaRemain = quotaRemain;
    }

    public int getQuota() {
        return quota;
    }

    public int getQuotaUsed() {
        return quotaUsed;
    }

    public int getQuotaRemain() {
        return quotaRemain;
    }
}
