package ru.yandex.webmaster3.viewer.http.importanturls;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.importanturls.data.ImportantUrl;

import java.util.List;
import java.util.Map;

/**
 * @author Oleg Bazdyrev
 */
public class GetImportantUrlsResponse implements ActionResponse.NormalResponse {

    private final int quota;
    private final int quotaUsed;
    private final int quotaRemain;
    private final List<ImportantUrl> urls;
    private final Map<ImportantUrlsStatGroup, Integer> stats;

    public GetImportantUrlsResponse(int quota, int quotaUsed, int quotaRemain, List<ImportantUrl> urls,
                                    Map<ImportantUrlsStatGroup, Integer> stats) {
        this.quota = quota;
        this.quotaUsed = quotaUsed;
        this.quotaRemain = quotaRemain;
        this.urls = urls;
        this.stats = stats;
    }

    public int getQuota() {
        return quota;
    }

    public int getQuotaUsed() {
        return quotaUsed;
    }

    public int getQuotaRemain() {
        return quotaRemain;
    }

    @Description("Список страниц, на которые есть подписка")
    public List<ImportantUrl> getUrls() {
        return urls;
    }

    public Map<ImportantUrlsStatGroup, Integer> getStats() {
        return stats;
    }
}
