package ru.yandex.webmaster3.viewer.http.importanturls;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

import java.util.List;

/**
 * Created by Oleg Bazdyrev on 31/01/2018.
 */
public class GetNonExistentImportantUrlsResponse implements ActionResponse.NormalResponse {

    private final int quota;
    private final int quotaUsed;
    private final int quotaRemain;
    private final List<String> nonExistentUrls;
    private final List<String> unmatchedHostUrls;

    public GetNonExistentImportantUrlsResponse(int quota, int quotaUsed, int quotaRemain,
                                               List<String> nonExistantUrls, List<String> unmatchedHostUrls) {
        this.quota = quota;
        this.quotaUsed = quotaUsed;
        this.quotaRemain = quotaRemain;
        this.nonExistentUrls = nonExistantUrls;
        this.unmatchedHostUrls = unmatchedHostUrls;
    }

    public int getQuota() {
        return quota;
    }

    public int getQuotaUsed() {
        return quotaUsed;
    }

    public int getQuotaRemain() {
        return quotaRemain;
    }

    @Description("Урлы, отсутствующие среди важных")
    public List<String> getNonExistentUrls() {
        return nonExistentUrls;
    }

    @Description("Урлы с несовпадающим хостом")
    public List<String> getUnmatchedHostUrls() {
        return unmatchedHostUrls;
    }
}
