package ru.yandex.webmaster3.viewer.http.importanturls;

import java.util.List;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.importanturls.ImportantUrlsService;
import ru.yandex.webmaster3.storage.importanturls.data.RecommendedUrl;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author Oleg Bazdyrev
 */
@ReadAction
@Description("Получение списка рекомендованных к отслеживанию урлов")
@Category("importanturls")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetRecommendedUrlsAction extends AbstractUserVerifiedHostAction<GetRecommendedUrlsRequest, GetRecommendedUrlsResponse> {
    private final ImportantUrlsService importantUrlsService;

    @Override
    public GetRecommendedUrlsResponse process(GetRecommendedUrlsRequest request) {
        List<RecommendedUrl> recommendedUrls = importantUrlsService.listRecommendedUrls(request.getHostId());

        ImportantUrlsService.ImportantUrlsQuota quota =
                importantUrlsService.getImportantUrlsQuota(request.getHostId());
        boolean importantAll = recommendedUrls.stream().allMatch(RecommendedUrl::isImportantUrl);

        return new GetRecommendedUrlsResponse(recommendedUrls, importantAll, quota.quotaIsEnd());
    }
}
