package ru.yandex.webmaster3.viewer.http.importanturls;

import java.util.List;

import lombok.Value;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.importanturls.data.RecommendedUrl;

/**
 * @author avhaliullin
 */
@Value
public class GetRecommendedUrlsResponse implements ActionResponse {
    @Description("список страниц, рекомендованых к отслеживанию")
    private final List<RecommendedUrl> recommendedUrls;
    @Description("все из рекомендованных уже добавленны в важные")
    private final boolean importantAll;
    @Description("закончилась квота")
    private final boolean quotaEnd;

    @Override
    public ActionStatus getRequestStatus() {
        return ActionStatus.SUCCESS;
    }
}
