package ru.yandex.webmaster3.viewer.http.indexing;

import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.AllArgsConstructor;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.link.DatePoint;
import ru.yandex.webmaster3.viewer.http.links.DateHistory;

/**
 * Created by ifilippov5 on 21.04.18.
 */
public abstract class GetIksHistoryResponse implements ActionResponse, DateHistory<IndexingIndicator.Miscelanous> {
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    public static class NormalResponse extends GetIksHistoryResponse implements ActionResponse.NormalResponse {
        private final boolean owner;
        private final String ownerDomain;
        private final List<IksHistory> histories;

        public NormalResponse(boolean owner, String ownerDomain, IksHistory iksHistory) {
            this.owner = owner;
            this.ownerDomain = ownerDomain;
            this.histories = Collections.singletonList(iksHistory);
        }

        public NormalResponse(boolean owner, String ownerDomain) {
            this.owner = owner;
            this.ownerDomain = ownerDomain;
            this.histories = Collections.singletonList(new IksHistory(Collections.emptyList()));
        }

        public boolean isOwner() {
            return owner;
        }

        public String getOwnerDomain() {
            return ownerDomain;
        }

        @Override
        public List<IksHistory> getHistories() {
            return histories;
        }
    }

    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    public static class IksHistory implements History<IndexingIndicator.Miscelanous> {
        private final List<DatePoint> data;

        @Override
        public IndexingIndicator.Miscelanous getIndicatorName() {
            return IndexingIndicator.Miscelanous.INDEXING_SQI;
        }

        @Override
        public List<DatePoint> getData() {
            return data;
        }
    }
}
