package ru.yandex.webmaster3.viewer.http.indexing2.download;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.searchquery.OrderDirection;
import ru.yandex.webmaster3.storage.indexing2.samples.IndexedUrlEventSampleFilter;
import ru.yandex.webmaster3.storage.indexing2.samples.IndexedUrlSampleFilter;
import ru.yandex.webmaster3.storage.indexing2.samples.dao.IndexedUrlEventSampleField;
import ru.yandex.webmaster3.storage.indexing2.samples.dao.IndexedUrlSampleField;
import ru.yandex.webmaster3.storage.indexing2.samples.dao.IndexedUrlSamplesOrderField;
import ru.yandex.webmaster3.storage.indexing2.samples.dao.IndexingEventsOrderField;
import ru.yandex.webmaster3.viewer.http.SiteTreeNodeAware;
import ru.yandex.webmaster3.viewer.http.download.DownloadRequest;

/**
 * Created by ifilippov5 on 28.02.17.
 */
public class DownloadIndexedUrlSamplesRequest extends DownloadRequest<IndexedUrlSampleField, IndexedUrlSampleFilter> implements SiteTreeNodeAware {
    private IndexedUrlSamplesOrderField orderBy = IndexedUrlSamplesOrderField.LAST_ACCESS;
    private OrderDirection orderDirection = OrderDirection.DESC;
    private Long nodeId;

    public IndexedUrlSamplesOrderField getOrderBy() {
        return orderBy;
    }

    @RequestQueryProperty
    @Description("поле для сортировки")
    public void setOrderBy(IndexedUrlSamplesOrderField orderBy) {
        this.orderBy = orderBy;
    }

    public OrderDirection getOrderDirection() {
        return orderDirection;
    }

    @RequestQueryProperty
    @Description("порядок сортировки")
    public void setOrderDirection(OrderDirection orderDirection) {
        this.orderDirection = orderDirection;
    }

    @Override
    public Long getNodeId() {
        return nodeId;
    }

    @Override
    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public enum OrderBy {
        LAST_ACCESS,
    }
}
