package ru.yandex.webmaster3.viewer.http.indexing2.events;

import java.util.stream.Collectors;

import lombok.Setter;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.HttpCodeInfo;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.indexing2.samples.IndexingSamplesService;
import ru.yandex.webmaster3.storage.indexing2.samples.dao.IndexingEventConditions;
import ru.yandex.webmaster3.storage.indexing2.samples.data.IndexingEventsAvailableCodes;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;
import ru.yandex.webmaster3.viewer.http.AbstractUrlFilteringAction;

/**
 * Created by leonidrom on 17/02/2017.
 */
@ReadAction
@Category("indexing")
public class IndexedUrlEventCodesAction extends AbstractUrlFilteringAction<IndexedUrlEventCodesRequest, IndexedUrlEventCodesResponse> {
    @Setter
    private IndexingSamplesService indexingSamplesService;

    @Override
    public IndexedUrlEventCodesResponse process(IndexedUrlEventCodesRequest request) throws WebmasterException {
        Condition condition = getNodeCondition(request.getNodeId(), request.getHostId(), IndexingEventConditions::buildPathCondition);
        IndexingEventsAvailableCodes codes =
                indexingSamplesService.getIndexingEventAvailableCodes(request.getHostId(), condition);
        return new IndexedUrlEventCodesResponse(
                codes.getPreviousCodes().stream().map(HttpCodeInfo::fromHttpStatus).collect(Collectors.toList()),
                codes.getCurrentCodes().stream().map(HttpCodeInfo::fromHttpStatus).collect(Collectors.toList())
        );
    }
}
