package ru.yandex.webmaster3.viewer.http.indexing2.events;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.searchquery.OrderDirection;
import ru.yandex.webmaster3.storage.indexing2.samples.IndexedUrlEventSampleFilter;
import ru.yandex.webmaster3.storage.indexing2.samples.dao.IndexingEventsOrderField;
import ru.yandex.webmaster3.viewer.http.AbstractPagerAwareUserHostNodeRequest;

import java.util.List;

/**
 * Created by leonidrom on 17/02/2017.
 */
public class IndexedUrlEventSamplesRequest extends AbstractPagerAwareUserHostNodeRequest {
    private List<IndexedUrlEventSampleFilter> parameterFilters;
    private IndexingEventsOrderField orderBy = IndexingEventsOrderField.LAST_ACCESS;
    private OrderDirection orderDirection = OrderDirection.DESC;

    public List<IndexedUrlEventSampleFilter> getParameterFilters() {
        return parameterFilters;
    }

    @Description("фильтр по полям")
    @RequestPostProperty
    public void setParameterFilters(List<IndexedUrlEventSampleFilter> parameterFilters) {
        this.parameterFilters = parameterFilters;
    }

    public IndexingEventsOrderField getOrderBy() {
        return orderBy;
    }

    @RequestQueryProperty
    @Description("поле для сортировки")
    public void setOrderBy(IndexingEventsOrderField orderBy) {
        this.orderBy = orderBy;
    }

    public OrderDirection getOrderDirection() {
        return orderDirection;
    }

    @RequestQueryProperty
    @Description("порядок сортировки")
    public void setOrderDirection(OrderDirection orderDirection) {
        this.orderDirection = orderDirection;
    }
}
