package ru.yandex.webmaster3.viewer.http.indexing2.events;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.util.TimeUtils;
import ru.yandex.webmaster3.storage.indexing2.history.IndexedUrlsCountHistoryService;
import ru.yandex.webmaster3.storage.indexing2.history.data.IndexingEventsHistoryIndicatorType;
import ru.yandex.webmaster3.storage.indexing2.history.data.IndexingHistoryData;
import ru.yandex.webmaster3.core.link.DatePoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
@Description("Получить историю изменений для загруженных страниц")
@ReadAction
@Category("indexing")
public class IndexingEventsCountHistoryAction extends Action<IndexingEventsCountHistoryRequest, IndexingEventsCountHistoryResponse> {
    private IndexedUrlsCountHistoryService indexedUrlsCountHistoryService;

    @Override
    public IndexingEventsCountHistoryResponse process(IndexingEventsCountHistoryRequest request) throws WebmasterException {
        Map<IndexingEventsHistoryIndicatorType, IndexingHistoryData> rawHistory =
                indexedUrlsCountHistoryService.getIndexingEventsCountHistory(
                        request.getHostId(),
                        request.getNodeId(),
                        request.getDateFrom(),
                        request.getDateTo()
                );
        List<IndexingEventsCountHistoryResponse.IndexingEventHistory> result = new ArrayList<>();
        for (Map.Entry<IndexingEventsHistoryIndicatorType, IndexingHistoryData> historyEntry : rawHistory.entrySet()) {
            List<DatePoint> indicatorHistory =
                    historyEntry.getValue().getTimestamp2Value().entrySet()
                            .stream()
                            .collect(Collectors.toMap(
                                    e -> e.getKey().toDateTime(TimeUtils.EUROPE_MOSCOW_ZONE).toLocalDate(),
                                    Map.Entry::getValue,
                                    Long::sum,
                                    TreeMap::new
                            ))
                            .entrySet()
                            .stream()
                            .map(e -> new DatePoint(e.getKey(), e.getValue()))
                            .collect(Collectors.toList());
            result.add(new IndexingEventsCountHistoryResponse.IndexingEventHistory(historyEntry.getKey(), indicatorHistory));
        }
        return new IndexingEventsCountHistoryResponse(result);
    }

    @Required
    public void setIndexedUrlsCountHistoryService(IndexedUrlsCountHistoryService indexedUrlsCountHistoryService) {
        this.indexedUrlsCountHistoryService = indexedUrlsCountHistoryService;
    }
}
