package ru.yandex.webmaster3.viewer.http.indexing2.events;

import org.joda.time.Instant;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.sitestructure.NewSiteStructure;
import ru.yandex.webmaster3.viewer.http.SiteTreeNodeAware;
import ru.yandex.webmaster3.viewer.http.host.verification.UsersVerifiedHostRequest;

/**
 * @author avhaliullin
 */
public class IndexingEventsCountHistoryRequest extends UsersVerifiedHostRequest implements SiteTreeNodeAware {
    private Long nodeId = NewSiteStructure.ROOT_NODE_ID;
    private Instant dateFrom;
    private Instant dateTo;

    @Override
    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public Long getNodeId() {
        return nodeId;
    }

    public Instant getDateFrom() {
        return dateFrom;
    }

    @Description("Начало диапазона дат")
    @RequestQueryProperty
    public void setDateFrom(Instant dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Instant getDateTo() {
        return dateTo;
    }

    @Description("Конец диапазона дат")
    @RequestQueryProperty
    public void setDateTo(Instant dateTo) {
        this.dateTo = dateTo;
    }
}

