package ru.yandex.webmaster3.viewer.http.indexing2.events;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.indexing2.history.data.IndexingEventsHistoryIndicatorType;
import ru.yandex.webmaster3.viewer.http.links.DateHistory;
import ru.yandex.webmaster3.core.link.DatePoint;

import java.util.List;

/**
 * @author avhaliullin
 */
public class IndexingEventsCountHistoryResponse implements ActionResponse.NormalResponse, DateHistory<IndexingEventsHistoryIndicatorType> {
    private final List<IndexingEventHistory> histories;

    public IndexingEventsCountHistoryResponse(List<IndexingEventHistory> histories) {
        this.histories = histories;
    }

    @Override
    public List<? extends History<IndexingEventsHistoryIndicatorType>> getHistories() {
        return histories;
    }

    public static class IndexingEventHistory implements DateHistory.History<IndexingEventsHistoryIndicatorType> {
        private final IndexingEventsHistoryIndicatorType indicatorType;
        private final List<DatePoint> data;

        public IndexingEventHistory(IndexingEventsHistoryIndicatorType indicatorType, List<DatePoint> data) {
            this.indicatorType = indicatorType;
            this.data = data;
        }

        @Override
        public IndexingEventsHistoryIndicatorType getIndicatorName() {
            return indicatorType;
        }

        @Override
        public List<DatePoint> getData() {
            return data;
        }
    }
}
