package ru.yandex.webmaster3.viewer.http.indexing2.urls;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;

import lombok.Value;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;

@Value
class DisallowedUrlsSamplesResponse implements ActionResponse.NormalResponse {
    List<PageSample> samples;
    int totalSamples;

    public DisallowedUrlsSamplesResponse(List<String> samples, int totalSamples) {
        this.samples = samples.stream().map(PageSample::new).collect(Collectors.toList());
        this.totalSamples = totalSamples;
    }

    public static class PageSample {
        private final URL url;

        public PageSample(String sample) {
            try {
                this.url = new URL(sample);
            } catch (MalformedURLException e) {
                throw new WebmasterException("Unexpected error",
                        new WebmasterErrorResponse.InternalUnknownErrorResponse(
                                getClass(), "Unexpected error"), e);
            }
        }

        public URL getUrl() {
            return url;
        }
    }
}
