package ru.yandex.webmaster3.viewer.http.indexing2.urls;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.HttpCodeInfo;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.host.HostDataState;
import ru.yandex.webmaster3.storage.host.service.HostService;
import ru.yandex.webmaster3.storage.indexing2.samples.IndexingSamplesService;
import ru.yandex.webmaster3.storage.indexing2.samples.dao.IndexedUrlSampleConditions;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;
import ru.yandex.webmaster3.viewer.http.AbstractUrlFilteringAction;
import ru.yandex.wmtools.common.util.http.YandexHttpStatus;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by leonidrom on 17/02/2017.
 */
@ReadAction
@Category("indexing")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class IndexedUrlCodesAction extends AbstractUrlFilteringAction<IndexedUrlCodesRequest, IndexedUrlCodesResponse> {

    private final IndexingSamplesService indexingSamplesService;

    @Override
    public IndexedUrlCodesResponse process(IndexedUrlCodesRequest request)
            throws WebmasterException {
        Condition condition = getNodeCondition(request.getNodeId(), request.getHostId(), IndexedUrlSampleConditions::buildPathCondition);
        List<YandexHttpStatus> codes =
                indexingSamplesService.getIndexedSampleAvailableCodes(request.getHostId(), condition);
        return new IndexedUrlCodesResponse(
                codes.stream().map(HttpCodeInfo::fromHttpStatus).collect(Collectors.toList())
        );
    }
}
