package ru.yandex.webmaster3.viewer.http.indexing2.urls;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.searchquery.OrderDirection;
import ru.yandex.webmaster3.storage.indexing2.samples.IndexedUrlSampleFilter;
import ru.yandex.webmaster3.storage.indexing2.samples.dao.IndexedUrlSamplesOrderField;
import ru.yandex.webmaster3.viewer.http.AbstractPagerAwareUserHostNodeRequest;

import java.util.List;

/**
 * Created by leonidrom on 17/02/2017.
 */
public class IndexedUrlSamplesRequest extends AbstractPagerAwareUserHostNodeRequest {
    private List<IndexedUrlSampleFilter> parameterFilters;
    private IndexedUrlSamplesOrderField orderBy = IndexedUrlSamplesOrderField.LAST_ACCESS;
    private OrderDirection orderDirection = OrderDirection.DESC;

    public List<IndexedUrlSampleFilter> getParameterFilters() {
        return parameterFilters;
    }

    @Description("фильтр по полям")
    @RequestPostProperty
    public void setParameterFilters(List<IndexedUrlSampleFilter> parameterFilters) {
        this.parameterFilters = parameterFilters;
    }

    public IndexedUrlSamplesOrderField getOrderBy() {
        return orderBy;
    }

    @RequestQueryProperty
    @Description("поле для сортировки")
    public void setOrderBy(IndexedUrlSamplesOrderField orderBy) {
        this.orderBy = orderBy;
    }

    public OrderDirection getOrderDirection() {
        return orderDirection;
    }

    @RequestQueryProperty
    @Description("порядок сортировки")
    public void setOrderDirection(OrderDirection orderDirection) {
        this.orderDirection = orderDirection;
    }

    public enum OrderBy {
        LAST_ACCESS,
    }
}

