package ru.yandex.webmaster3.viewer.http.indexing2.urls;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.viewer.http.indexing2.urls.data.IndexedUrlStatusGroup;
import ru.yandex.webmaster3.viewer.http.links.DateHistory;
import ru.yandex.webmaster3.core.link.DatePoint;

import java.util.List;

/**
 * @author avhaliullin
 */
public class IndexedUrlsCountHistoryResponse implements ActionResponse.NormalResponse, DateHistory<IndexedUrlStatusGroup> {
    private final List<IndexedUrlsHistory> histories;

    public IndexedUrlsCountHistoryResponse(List<IndexedUrlsHistory> histories) {
        this.histories = histories;
    }

    @Override
    public List<IndexedUrlsHistory> getHistories() {
        return histories;
    }

    public static class IndexedUrlsHistory implements History<IndexedUrlStatusGroup> {
        private final List<DatePoint> data;
        private final IndexedUrlStatusGroup statusGroup;

        public IndexedUrlsHistory(List<DatePoint> data, IndexedUrlStatusGroup statusGroup) {
            this.data = data;
            this.statusGroup = statusGroup;
        }

        @Override
        public IndexedUrlStatusGroup getIndicatorName() {
            return statusGroup;
        }

        @Override
        public List<DatePoint> getData() {
            return data;
        }
    }
}
