package ru.yandex.webmaster3.viewer.http.indexing2.urls.data;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.core.codes.DownloadedHttpCodeGroup;

import java.util.Optional;

/**
 * @author avhaliullin
 */
public enum  IndexedUrlStatusGroup implements IntEnum{
    HTTP_2XX(0),
    HTTP_3XX(1),
    HTTP_4XX(2),
    HTTP_5XX(3),
    OTHERS(4),
    ;

    private final int value;

    IndexedUrlStatusGroup(int value) {
        this.value = value;
    }



    public static IndexedUrlStatusGroup of(int httpCode) {
        Optional<DownloadedHttpCodeGroup> grpOpt = DownloadedHttpCodeGroup.get(httpCode);
        if (grpOpt.isPresent()) {
            switch (grpOpt.get()) {
                case DOWNLOADED_2XX:
                    return HTTP_2XX;

                case DOWNLOADED_3XX:
                    return HTTP_3XX;

                case DOWNLOADED_4XX:
                    return HTTP_4XX;

                case DOWNLOADED_5XX:
                    return HTTP_5XX;
            }
        }

        return OTHERS;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<IndexedUrlStatusGroup> R = IntEnumResolver.r(IndexedUrlStatusGroup.class);
}
